<?php
// Form sederhana: render input berdasarkan kolom tabel
$model = new \App\Models\GenericModel();
$model->setTable($table);
$fields = $model->allowedFields;
$row = $row ?? null;
?>
<div class="card">
    <div class="card-body">
        <form id="crudForm">
            <?php if ($row): ?>
                <input type="hidden" name="<?= esc($model->primaryKey) ?>" value="<?= esc($row[$model->primaryKey]) ?>">
            <?php endif; ?>


            <?php foreach ($fields as $f):
                if ($f === $model->primaryKey) continue; ?>
                <div class="form-group">
                    <label><?= esc($f) ?></label>
                    <input type="text" name="<?= esc($f) ?>" class="form-control" value="<?= esc($row[$f] ?? '') ?>">
                </div>
            <?php endforeach; ?>


            <button class="btn btn-primary">Simpan</button>
            <a href="<?= site_url('crud/' . $table) ?>" class="btn btn-secondary">Kembali</a>
        </form>
    </div>
</div>