<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Updater</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>

<body class="p-4">

    <h3>Updater Aplikasi</h3>
    <div id="status" class="alert alert-info">Menunggu aksi...</div>

    <button id="checkUpdate" class="btn btn-primary mb-3">Cek Update Online</button>

    <form id="offlineForm" enctype="multipart/form-data">
        <input type="file" name="update_zip" class="form-control mb-2" required>
        <button class="btn btn-success">Terapkan Update Offline</button>
    </form>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script>
        $('#checkUpdate').on('click', function() {
            $('#status').text('Memeriksa versi...');
            $.getJSON('<?= site_url('updater/check') ?>', function(res) {
                if (res.status === 'available') {
                    if (confirm(`Versi baru (${res.new_version}) tersedia. Download dan terapkan sekarang?`)) {
                        $.post('<?= site_url('updater/apply') ?>', {
                            url: res.url
                        }, function(r) {
                            alert(r.message);
                            location.reload();
                        }, 'json');
                    }
                } else {
                    alert(res.message);
                }
            });
        });

        $('#offlineForm').on('submit', function(e) {
            e.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                url: '<?= site_url('updater/applyOffline') ?>',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(res) {
                    alert(res.message);
                    location.reload();
                }
            });
        });
    </script>

</body>

</html>