$(function() {
// 🧩 Tambahkan variabel global di luar handler
let isLoadingTable = false;
window.activeViewTable = window.activeViewTable || null;
// === Sidebar Klik Tabel ===
// === Sidebar Klik Tabel (dengan proteksi loading & localStorage) ===
$(document).on('click', '.table-link', function (e) {
  e.preventDefault();

  // 🚫 Cegah klik ganda
  if (isLoadingTable) {
    console.warn('⏳ Sedang memuat tabel, harap tunggu...');
    return;
  }
  isLoadingTable = true;

  // 🔹 Ambil nama tabel dari beberapa sumber
  const table =
    typeof activeViewTable !== 'undefined' && activeViewTable
      ? activeViewTable
      : $(this).data('table') || window.currentTable;

  if (!table) {
    console.error('Nama tabel tidak ditemukan.');
    Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
    isLoadingTable = false;
    return;
  }

  // ✅ Simpan tabel aktif global & localStorage
  window.currentTable = table;
  localStorage.setItem('lastSidebarTable', table);
  console.log('💾 Menyimpan tabel terakhir ke localStorage:', table);

  // 🔹 Update tampilan sidebar
  $('.table-link').removeClass('active');
  $(this).addClass('active');

  // 🔹 Tampilkan pesan loading
  $('#crud-content').html(`
    <div class="text-center p-5">
      Memuat data <b>${table}</b>...
    </div>
  `);

  // 🔹 Load konten dari server
  $.get(CRUD.baseUrl + '/crud/loadTableContent/' + table, function (html) {
    $('#crud-content').html(html);
    initDataTable(table);
  })
    .fail(function (xhr) {
      console.error('❌ Gagal memuat tabel:', xhr.responseText);
      Swal.fire('Error', 'Gagal memuat tabel: ' + table, 'error');
    })
    .always(function () {
      isLoadingTable = false; // reset agar bisa diklik lagi
    });
});



// === Inisialisasi DataTable + event CRUD ===
window.initDataTable = function(table) {
  // 🔹 Pastikan tabel aktif tersimpan secara global
  if (typeof activeViewTable !== 'undefined' && activeViewTable) {
    window.currentTable = activeViewTable;
  } else if (table) {
    window.currentTable = table;
  } else if (!window.currentTable) {
    console.error('Tabel aktif tidak ditemukan di initDataTable.');
    Swal.fire('Error', 'Tabel aktif tidak ditemukan.', 'error');
    return;
  }

  const $table = $('#datatable');
  if (!$table.length) return;

  // ✅ Cegah error "Incorrect column count"
  const $theadCols = $table.find('thead th').length;
  const $tbody = $table.find('tbody');
  const $rows = $tbody.find('tr');

  if ($rows.length === 0) {
    // buat 1 baris kosong dengan jumlah kolom sesuai header
    let emptyRow = '<tr>';
    for (let i = 0; i < $theadCols; i++) {
      emptyRow += '<td></td>';
    }
    emptyRow += '</tr>';
    $tbody.html(emptyRow);
  }

  // 🔹 Hancurkan DataTable sebelumnya (kalau ada), lalu buat baru
  const dt = $table.DataTable({
    destroy: true,
    pageLength: 10,
    language: { url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json' }
  });

  // ✅ Simpan instance DataTable dan nama tabel ke elemen
  $table.data('DataTableInstance', dt);
  $table.data('tableName', window.currentTable);

  console.log('✅ DataTable diinisialisasi untuk tabel:', window.currentTable);
};


// === Simpan (Tambah/Edit) — dengan dukungan Active View & currentTable ===
$(document).off('submit', '#crudForm').on('submit', '#crudForm', function(e) {
  e.preventDefault();

  const formData = $(this).serialize();

  // 🔹 Tentukan tabel aktif secara aman
  const table = (typeof activeViewTable !== 'undefined' && activeViewTable)
    ? activeViewTable
    : $(this).data('table') || window.currentTable;

  if (!table) {
    console.error('Nama tabel tidak ditemukan.');
    Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
    return;
  }

  console.log('🟢 Menyimpan data untuk tabel:', table);

  $.post(CRUD.baseUrl + '/crud/save/' + table, formData, function(res) {
    if (res.status === 'success') {
      $('#formModal').modal('hide');

      Swal.fire({
        icon: 'success',
        text: res.message || 'Data berhasil disimpan.',
        timer: 1000,
        showConfirmButton: false
      });

      // 🔹 Reload tabel setelah simpan
      $.get(CRUD.baseUrl + '/crud/loadTableContent/' + table, function(html) {
        $('#crud-content').html(html);

        // 🔹 Highlight baris baru / diupdate jika last_id dikembalikan
        if (res.last_id) {
          const $row = $('#datatable tr[data-id="' + res.last_id + '"]');
          if ($row.length) {
            $row.addClass('highlight');
            setTimeout(() => $row.removeClass('highlight'), 2000);
          }
        }

        // ✅ Re-inisialisasi DataTable
        initDataTable(table);
      });
    } else {
      Swal.fire({
        icon: 'error',
        text: res.message || 'Gagal menyimpan data.',
        timer: 2000,
        showConfirmButton: false
      });
    }
  }, 'json').fail(function() {
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Tidak dapat menghubungi server.',
      timer: 2000,
      showConfirmButton: false
    });
  });
});

// === View (Detail) — dengan dukungan Active View & currentTable ===
$(document).off('click', '.view-btn, [id^="btn-view-"]').on('click', '.view-btn, [id^="btn-view-"]', function() {
  // 🔹 Tentukan tabel aktif secara aman
  const table = (typeof activeViewTable !== 'undefined' && activeViewTable)
    ? activeViewTable
    : $(this).data('table') || window.currentTable;

  if (!table) {
    console.error('Nama tabel tidak ditemukan untuk aksi View.');
    Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
    return;
  }

  // 🔹 Ambil ID dari atribut data-id atau dari ID tombol (misal: btn-view-users-12)
  let id = $(this).data('id');
  if (!id && this.id) {
    const parts = this.id.split('-');
    id = parts.length >= 4 ? parts.slice(3).join('-') : null;
  }

  if (!id) {
    console.error('ID data tidak ditemukan untuk aksi View.');
    Swal.fire('Error', 'ID data tidak ditemukan.', 'error');
    return;
  }

  console.log(`🔍 View detail data dari tabel [${table}] dengan ID: ${id}`);

  // === AJAX Request ===
  $.get(CRUD.baseUrl + '/crud/get/' + table + '/' + id, function(res) {
    if (res.status === 'success') {
      const data = res.data;
      let html = `
        <table class="table table-striped table-bordered">
          <tbody>
      `;

      // 🔹 Loop setiap field dan tampilkan aman
      for (const field in data) {
        const safeValue = $('<div>').text(data[field] ?? '-').html(); // Escape HTML
        html += `
          <tr>
            <th class="text-muted" style="width: 30%; text-transform: capitalize;">${field}</th>
            <td class="fw-bold">${safeValue}</td>
          </tr>
        `;
      }

      html += `
          </tbody>
        </table>
      `;

      // 🔹 Masukkan hasil ke modal
      $('#viewContent').html(html);
      $('#viewModal').modal('show');
    } else {
      Swal.fire('Gagal', res.message || 'Tidak dapat mengambil data.', 'error');
    }
  }, 'json').fail(function() {
    Swal.fire('Error', 'Terjadi kesalahan saat mengambil data dari server.', 'error');
  });
});

// === Tambah & Edit — dengan dukungan Active View & currentTable ===
function generateFormFields(meta, data = {}) {
  const $tbody = $('#crudFormTable tbody');
  $tbody.empty();

  // 🔹 Tentukan tabel aktif secara aman
  const table = (typeof activeViewTable !== 'undefined' && activeViewTable)
    ? activeViewTable
    : window.currentTable;

  if (!table) {
    console.error('Tabel aktif tidak ditemukan saat generate form.');
    Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
    return;
  }

  // ✅ Simpan nama tabel ke form untuk referensi simpan
  $('#crudForm').attr('data-table', table);

  // 🔹 Tangani Primary Key (jika ada)
  const pkCol = meta.find(c => c.key === 'PRI');
  if (pkCol) {
    // Hapus field hidden lama agar tidak duplikat
    $('#crudForm [name="' + pkCol.name + '"]').remove();
    // Tambahkan kembali hidden input untuk PK
    $('#crudForm').prepend(
      `<input type="hidden" name="${pkCol.name}" value="${data[pkCol.name] || ''}">`
    );
  }

  // 🔹 Daftar kolom yang akan di-skip (kolom sistem)
  const skipCols = [
    'created_at', 'updated_at', 'deleted_at',
    'timestamp', 'created_by', 'updated_by'
  ];

  // 🔹 Loop setiap kolom meta
  meta.forEach(col => {
    if (col.key === 'PRI' || skipCols.includes(col.name.toLowerCase())) return;

    const type = col.type.toLowerCase();
    const value = data[col.name] ?? '';
    let input = '';

    // === ENUM / SET ===
    if (type.startsWith('enum') || type.startsWith('set')) {
      const options = type.match(/\((.*?)\)/)[1]
        .replace(/'/g, '')
        .split(',')
        .map(opt => opt.trim());

      input += `<select name="${col.name}" class="form-control">`;
      options.forEach(o => {
        const selected = (o === value) ? 'selected' : '';
        input += `<option value="${o}" ${selected}>${o}</option>`;
      });
      input += `</select>`;

    // === DATE / DATETIME ===
    } else if (type.includes('date')) {
      input = `<input type="date" name="${col.name}" class="form-control" value="${value}">`;

    // === NUMERIC TYPES ===
    } else if (type.includes('int') || type.includes('decimal') || type.includes('float')) {
      input = `<input type="number" name="${col.name}" class="form-control" value="${value}">`;

    // === TEXT AREA ===
    } else if (type.includes('text')) {
      input = `<textarea name="${col.name}" class="form-control" rows="3">${value}</textarea>`;

    // === DEFAULT (VARCHAR / CHAR / DLL) ===
    } else {
      input = `<input type="text" name="${col.name}" class="form-control" value="${value}">`;
    }

    // 🔹 Tambahkan ke tabel form
    $tbody.append(`
      <tr>
        <td class="px-2 py-2" style="width:30%; font-weight:bold; color:#6c757d;">
          ${col.name}
        </td>
        <td class="px-2 py-2">
          ${input}
        </td>
      </tr>
    `);
  });

  console.log('🧾 Form field digenerate untuk tabel:', table);
}

  // === Tambah ===
$(document).off('click', '.btn-add, [id^="btn-tambah-"]').on('click', '.btn-add, [id^="btn-tambah-"]', function() {
    // ✅ Tentukan tabel target dengan prioritas:
    // 1️⃣ activeViewTable
    // 2️⃣ data-table pada tombol
    // 3️⃣ window.table (default global)
    const targetTable = activeViewTable ? activeViewTable : $(this).data('table') || window.table;

    if (!targetTable) {
        Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
        return;
    }

    $.get(CRUD.baseUrl + '/crud/structure/' + targetTable, function(res) {
        if (res.status === 'success') {
            generateFormFields(res.meta); // kosongkan data (tambah)
            $('#formModal .modal-title').text('Tambah Data ' + targetTable);
            $('#formModal').modal('show');
        } else {
            Swal.fire('Error', 'Gagal memuat struktur tabel.', 'error');
        }
    });
});


// === Edit ===
$(document).off('click', '.edit-btn, [id^="btn-edit-"]').on('click', '.edit-btn, [id^="btn-edit-"]', function() {
    // ✅ Ambil ID data (bisa dari data-id atau dari id tombol)
    let id = $(this).data('id');
    if (!id && this.id) {
        const parts = this.id.split('-');
        id = parts.length >= 4 ? parts.slice(3).join('-') : null;
    }

    if (!id) {
        Swal.fire('Error', 'ID data tidak ditemukan.', 'error');
        return;
    }

    // ✅ Tentukan tabel target dengan urutan prioritas yang sama
    const targetTable = activeViewTable ? activeViewTable : $(this).data('table') || window.table;

    if (!targetTable) {
        Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
        return;
    }

    $.when(
        $.get(CRUD.baseUrl + '/crud/structure/' + targetTable),
        $.get(CRUD.baseUrl + '/crud/get/' + targetTable + '/' + id)
    ).done(function(structRes, dataRes) {
        const struct = structRes[0];
        const rowRes = dataRes[0];

        if (struct.status === 'success' && rowRes.status === 'success') {
            generateFormFields(struct.meta, rowRes.data);
            $('#formModal .modal-title').text('Edit Data ' + targetTable);
            $('#formModal').modal('show');
        } else {
            Swal.fire('Error', 'Gagal memuat struktur atau data.', 'error');
        }
    }).fail(function() {
        Swal.fire('Error', 'Terjadi kesalahan saat memuat data dari server.', 'error');
    });
});

// === Hapus ===
$(document).off('click', '.delete-btn, [id^="btn-delete-"]').on('click', '.delete-btn, [id^="btn-delete-"]', function() {
    // ✅ Ambil ID dari data-id atau dari ID tombol
    let id = $(this).data('id');
    if (!id && this.id) {
        const parts = this.id.split('-');
        id = parts.length >= 4 ? parts.slice(3).join('-') : null;
    }

    if (!id) {
        Swal.fire('Error', 'ID data tidak ditemukan.', 'error');
        return;
    }

    // ✅ Tentukan tabel target dengan prioritas:
    // 1️⃣ activeViewTable
    // 2️⃣ data-table dari tombol
    // 3️⃣ window.table sebagai fallback
    const targetTable = activeViewTable ? activeViewTable : $(this).data('table') || window.table;

    if (!targetTable) {
        Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
        return;
    }

    // 🔔 Konfirmasi sebelum hapus
    Swal.fire({
        title: 'Yakin hapus data ini?',
        text: 'Data yang dihapus tidak bisa dikembalikan!',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, hapus',
        cancelButtonText: 'Batal'
    }).then(result => {
        if (result.isConfirmed) {
            $.post(CRUD.baseUrl + '/crud/delete/' + targetTable + '/' + id, function(res) {
                if (res.status === 'success') {
                    Swal.fire({
                        icon: 'success',
                        title: res.message || 'Data berhasil dihapus',
                        timer: 1500,
                        showConfirmButton: false
                    });

                    // 🔄 Reload tabel (mendukung active view)
                    $.get(CRUD.baseUrl + '/crud/loadTableContent/' + targetTable, function(html) {
                        $('#crud-content').html(html);
                        initDataTable(targetTable); // ✅ reinit datatable
                    }).fail(function() {
                        Swal.fire('Error', 'Gagal memuat ulang data tabel.', 'error');
                    });

                } else {
                    Swal.fire({
                        icon: 'error',
                        title: res.message || 'Gagal menghapus data.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                }
            }, 'json').fail(function() {
                Swal.fire('Error', 'Terjadi kesalahan pada server.', 'error');
            });
        }
    });
});
// === Hapus Semua Data ===
$(document).off('click', '.btn-delete-all, [id^="btn-deleteall-"]').on('click', '.btn-delete-all, [id^="btn-deleteall-"]', function() {
    // ✅ Tentukan tabel aktif dengan prioritas (ActiveView > data-table > window.table)
    const targetTable = activeViewTable ? activeViewTable : $(this).data('table') || window.table;

    if (!targetTable) {
        Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
        return;
    }

    Swal.fire({
        title: 'Yakin hapus semua data?',
        text: 'Semua data di tabel ini akan dihapus permanen!',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, hapus semua',
        cancelButtonText: 'Batal'
    }).then(result => {
        if (result.isConfirmed) {
            $.post(CRUD.baseUrl + '/crud/deleteAll/' + targetTable, function(res) {
                if (res.status === 'success') {
                    Swal.fire({
                        icon: 'success',
                        title: res.message || 'Semua data berhasil dihapus.',
                        timer: 1500,
                        showConfirmButton: false
                    });

                    // 🔄 Reload ulang tabel sesuai mode (ActiveView / normal)
                    $.get(CRUD.baseUrl + '/crud/loadTableContent/' + targetTable, function(html) {
                        $('#crud-content').html(html);
                        initDataTable(targetTable);
                    }).fail(function() {
                        Swal.fire('Error', 'Gagal memuat ulang data tabel.', 'error');
                    });

                } else {
                    Swal.fire({
                        icon: 'error',
                        title: res.message || 'Gagal menghapus semua data.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                }
            }, 'json').fail(function() {
                Swal.fire('Error', 'Terjadi kesalahan pada server.', 'error');
            });
        }
    });
});


// === Export ===
$(document).off('click', '.btn-export, [id^="btn-export-"]').on('click', '.btn-export, [id^="btn-export-"]', function() {
    // ✅ Tentukan tabel aktif dengan prioritas
    const targetTable = activeViewTable ? activeViewTable : $(this).data('table') || window.table;

    if (!targetTable) {
        Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
        return;
    }

    // 📦 Arahkan ke endpoint export
    window.location.href = CRUD.baseUrl + '/crud/export/' + targetTable;
});


// === Import ===
$(document).off('click', '.btn-import, [id^="btn-import-"]').on('click', '.btn-import, [id^="btn-import-"]', function() {
    // ✅ Tentukan tabel target
    const targetTable = activeViewTable ? activeViewTable : $(this).data('table') || window.table;

    if (!targetTable) {
        Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
        return;
    }

    // 🗂️ Simpan nama tabel ke modal import
    $('#importModal').data('table', targetTable);

    // 🏷️ Ubah judul modal agar sesuai dengan tabel aktif
    $('#importModal .modal-title').text('Import Data ' + targetTable);

    // 📤 Tampilkan modal
    $('#importModal').modal('show');
});

 // === Import Form Submit ===
$(document).off('submit', '#importForm').on('submit', '#importForm', function(e) {
    e.preventDefault();

    const formData = new FormData(this);

    // ✅ Tentukan tabel aktif dengan prioritas (ActiveView → data-table → window.table)
    const targetTable = activeViewTable ? activeViewTable : $('#importModal').data('table') || $(this).data('table') || window.table;

    if (!targetTable) {
        Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
        return;
    }

    Swal.fire({
        title: 'Mengupload data...',
        text: 'Mohon tunggu sebentar',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    $.ajax({
        url: CRUD.baseUrl + '/crud/import/' + targetTable,
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        dataType: 'json',
        success: function(res) {
            Swal.close();

            if (res.status === 'success') {
                $('#importModal').modal('hide');

                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    html: `<b>${res.inserted}</b> data baru ditambahkan<br><b>${res.updated}</b> data diperbarui.`,
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    // 🔄 Reload ulang tabel sesuai mode aktif
                    $.get(CRUD.baseUrl + '/crud/loadTableContent/' + targetTable, function(html) {
                        $('#crud-content').html(html);
                        initDataTable(targetTable);

                        // ✨ Highlight baris baru jika backend mengembalikan inserted_ids
                        if (res.inserted_ids && Array.isArray(res.inserted_ids)) {
                            res.inserted_ids.forEach(id => {
                                const row = $('#datatable tr[data-id="' + id + '"]');
                                row.addClass('highlight');
                                setTimeout(() => row.removeClass('highlight'), 3000);
                            });
                        }
                    }).fail(function() {
                        Swal.fire('Error', 'Gagal memuat ulang tabel setelah impor.', 'error');
                    });
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Gagal',
                    text: res.message || 'Terjadi kesalahan saat memproses file.'
                });
            }
        },
        error: function() {
            Swal.close();
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Gagal mengunggah file atau koneksi ke server bermasalah.'
            });
        }
    });
});

 
}); // Penutup untuk $(function()

// === Reload Tabel (mendukung Active View) ===
function reloadTable(inputTable = null) {
    // ✅ Tentukan tabel target berdasarkan prioritas:
    // 1️⃣ activeViewTable (jika aktif)
    // 2️⃣ parameter function (inputTable)
    // 3️⃣ window.table (global fallback)
    const targetTable = activeViewTable ? activeViewTable : inputTable || window.table;

    if (!targetTable) {
        Swal.fire('Error', 'Nama tabel tidak ditemukan untuk reload.', 'error');
        return;
    }

    $('#crud-content').html(`
        <div class="text-center p-4">
            Memuat ulang data <b>${targetTable}</b>...
        </div>
    `);

    $.get(CRUD.baseUrl + '/crud/loadTableContent/' + targetTable, function(html) {
        $('#crud-content').html(html);
        initDataTable(targetTable); // ✅ tetap di sini juga
    }).fail(function() {
        Swal.fire('Error', 'Gagal memuat ulang data tabel.', 'error');
    });
}


// === Reset form ke mode normal setelah modal ditutup ===
$('#formModal').on('hidden.bs.modal', function() {
    // ✅ Kembalikan semua input form ke kondisi aktif (bukan readonly)
    $('#crudForm input, #crudForm select, #crudForm textarea')
        .prop('readonly', false)
        .prop('disabled', false);

    // ✅ Tampilkan kembali tombol submit
    $('#crudForm button[type=submit]').show();

    // ✅ (Opsional) Hapus hidden field primary key agar form tambah bersih
    $('#crudForm input[type="hidden"]').remove();
});
// === Print Table (mendukung Active View & fallback otomatis) ===
$(document)
  .off('click', '.btn-print, [id^="btn-print-"]')
  .on('click', '.btn-print, [id^="btn-print-"]', function() {
    // ✅ Tentukan tabel target berdasarkan prioritas:
    // 1️⃣ activeViewTable (jika aktif)
    // 2️⃣ data-table dari tombol
    // 3️⃣ window.table sebagai fallback terakhir
    const targetTable = activeViewTable ? activeViewTable : $(this).data('table') || window.table;

    if (!targetTable) {
      Swal.fire('Error', 'Nama tabel tidak ditemukan untuk dicetak.', 'error');
      return;
    }

    // ✅ Ambil elemen tabel utama di dalam konten CRUD
    const tableContent = document.querySelector('#crud-content table');
    if (!tableContent) {
      Swal.fire('Oops', 'Tabel data tidak ditemukan!', 'warning');
      return;
    }

    // ✅ Ambil judul tabel (biasanya elemen h4 di atas tabel)
    const titleElement = document.querySelector('#crud-content h4');
    let titleText = titleElement ? titleElement.innerText.trim() : 'Data Tabel';

    // Tambahkan nama tabel bila belum ada
    if (targetTable && !titleText.toLowerCase().includes(targetTable.toLowerCase())) {
      titleText += ` (${targetTable})`;
    }

    // ✅ Kloning tabel agar tidak mengubah tampilan asli
    const clonedTable = tableContent.cloneNode(true);

    // === Hapus kolom aksi (tombol edit/delete) ===
    clonedTable.querySelectorAll('th, td').forEach(cell => {
      if (
        cell.querySelector('.btn') || // tombol di dalam cell
        /aksi|action/i.test(cell.innerText.trim()) // teks "Aksi"/"Action"
      ) {
        const colIndex = cell.cellIndex;
        // Hapus kolom dari semua baris
        clonedTable.querySelectorAll('tr').forEach(row => {
          if (row.cells[colIndex]) row.deleteCell(colIndex);
        });
      }
    });

    // === Buka jendela cetak baru ===
    const printWindow = window.open('', '', 'width=1000,height=700');
    printWindow.document.write(`
      <html>
        <head>
          <title>${titleText}</title>
          <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
          <style>
            body { padding: 20px; font-size: 14px; color: #000; }
            table { width: 100%; border-collapse: collapse; margin-top: 10px; }
            th, td { border: 1px solid #999; padding: 8px; text-align: left; }
            th { background-color: #f8f9fa; }
            h4 { margin-bottom: 20px; text-align: center; }
            @media print {
              @page { margin: 20mm; }
            }
          </style>
        </head>
        <body>
          <h4>${titleText}</h4>
          ${clonedTable.outerHTML}
          <script>window.onload = function(){ window.print(); }</script>
        </body>
      </html>
    `);
    printWindow.document.close();
  });
// === Toggle Status (mendukung Active View & fallback otomatis) ===
$(document).on('change', '.toggle-status, [id^="switch_"]', function() {
    // ✅ Tentukan tabel target berdasarkan prioritas:
    // 1️⃣ activeViewTable (jika ada)
    // 2️⃣ data-table dari elemen
    // 3️⃣ window.table sebagai fallback terakhir
    const targetTable = activeViewTable ? activeViewTable : $(this).data('table') || window.table;

    if (!targetTable) {
        Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
        return;
    }

    // Ambil nama kolom dari data attribute
    const column = $(this).data('column');

    // Ambil ID record dari data-field atau pola id elemen
    let id = $(this).data('field');
    if (!id && this.id) {
        // Pola umum: switch_<table>_<column>_<id>
        const parts = this.id.split('_');
        id = parts.length >= 4 ? parts.slice(3).join('_') : null;
    }

    if (!id || !column) {
        Swal.fire('Error', 'Data toggle tidak lengkap (kolom atau ID tidak ditemukan).', 'error');
        return;
    }

    // Tentukan status baru berdasarkan posisi checkbox
    const status = $(this).is(':checked') ? 'aktif' : 'nonaktif';

    // ✅ Kirim permintaan ke backend
    $.post(CRUD.baseUrl + '/crud/updateToggle', { 
        table: targetTable, 
        column, 
        id, 
        status 
    }, function(res) {
        if (res.status === 'success') {
            // Opsional → Tampilkan notifikasi ringan / log
            // console.log(`Status ${column} di tabel ${targetTable} berhasil diperbarui.`);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: res.message || 'Terjadi kesalahan saat memperbarui data.',
                timer: 2000,
                showConfirmButton: false
            });
        }
    }, 'json').fail(function() {
        Swal.fire({
            icon: 'error',
            title: 'Gagal',
            text: 'Tidak dapat terhubung ke server.',
            timer: 2000,
            showConfirmButton: false
        });
    });
});

// === Generate (dengan dukungan Active View) ===
$(document).off('click', '.btn-generate, [id^="btn-generate-"]').on('click', '.btn-generate, [id^="btn-generate-"]', function() {
    // ✅ Tentukan tabel aktif berdasarkan prioritas
    const table = activeViewTable ? activeViewTable : $(this).data('table') || window.table;

    if (!table) {
        console.error('Nama tabel tidak ditemukan di tombol atau context.');
        Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
        return;
    }

    console.log('🔧 Generate button clicked for table:', table);

    Swal.fire({
        title: 'Generate Data?',
        text: 'Data otomatis akan dibuat untuk tabel: ' + table,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Ya, lanjutkan',
        cancelButtonText: 'Batal'
    }).then(result => {
        if (!result.isConfirmed) return;

        Swal.fire({
            title: 'Memproses...',
            text: 'Sedang mengisi data otomatis, mohon tunggu sebentar...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: CRUD.baseUrl + '/crud/generate/' + table,
            type: 'GET',
            dataType: 'json',
            success: function(res) {
                Swal.close();
                console.log('✅ Generate result:', res);

                if (res.status === 'success') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        html: res.message || 'Generate selesai.',
                        timer: 2000,
                        showConfirmButton: false
                    });

                    // 🔄 Reload tabel setelah generate (mengikuti Active View)
                    reloadTable(table);
                } else {
                    Swal.fire('Gagal', res.message || 'Terjadi kesalahan saat generate data.', 'error');
                }
            },
            error: function(xhr) {
                Swal.close();
                console.error('❌ AJAX Error:', xhr.responseText);
                Swal.fire('Error', 'Tidak dapat menghubungi server (' + xhr.status + ')', 'error');
            }
        });
    });
});


// ============================================================
// === Active View ===
$(document)
  .off('click', '.activeView, [id^="btn-activeview-"]')
  .on('click', '.activeView, [id^="btn-activeview-"]', function (e) {
    e.preventDefault();

    const table = activeViewTable
      ? activeViewTable
      : $(this).data('table') || window.table;

    if (!table) {
      console.error('Nama tabel tidak ditemukan di tombol activeView.');
      Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
      return;
    }

    const $btn = $('.activeView[data-table="' + table + '"]');
    const isCurrentlyActive =
      (activeViewTable && activeViewTable === table) ||
      $btn.hasClass('btn-success');

    const actionTitle = isCurrentlyActive ? 'Nonaktifkan View?' : 'Aktifkan View?';
    const actionText = isCurrentlyActive
      ? 'Apakah kamu ingin mematikan tampilan aktif untuk tabel: ' + table + '?'
      : 'Apakah kamu ingin mengatur tampilan aktif untuk tabel: ' + table + '?';
    const confirmText = isCurrentlyActive ? 'Ya, nonaktifkan!' : 'Ya, aktifkan!';

    Swal.fire({
      title: actionTitle,
      text: actionText,
      icon: 'question',
      showCancelButton: true,
      confirmButtonText: confirmText,
      cancelButtonText: 'Batal',
    }).then((result) => {
      if (!result.isConfirmed) return;

      // 🔄 Tampilkan indikator loading di tombol
      const originalIcon = $btn.find('i').attr('class');
      const originalText = $btn.text();
      $btn
        .prop('disabled', true)
        .html('<i class="fa fa-spinner fa-spin"></i> Memproses...');

      Swal.fire({
        title: 'Memproses...',
        text: isCurrentlyActive
          ? 'Mematikan tampilan aktif...'
          : 'Mengatur tampilan aktif...',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading(),
      });

      $.ajax({
        url: CRUD.baseUrl + '/crud/activeView/' + table,
        type: 'POST',
        dataType: 'json',
        success: function (response) {
          Swal.close();

          if (response.success) {
            const newActive =
              typeof response.active !== 'undefined'
                ? response.active
                : !isCurrentlyActive;

            Swal.fire({
              icon: 'success',
              title: 'Berhasil!',
              text:
                response.message ||
                (newActive
                  ? 'Active view diaktifkan.'
                  : 'Active view dinonaktifkan.'),
              timer: 1200,
              showConfirmButton: false,
            });

            // === Reset semua tombol activeView ke default ===
            $('.activeView')
              .removeClass('btn-success')
              .addClass('btn-secondary')
              .find('i')
              .removeClass('fa-eye')
              .addClass('fa-check');

            // === Jika tabel baru diaktifkan, ubah tombolnya ===
            if (newActive) {
              $btn.removeClass('btn-secondary').addClass('btn-success');
              $btn.find('i').removeClass('fa-check').addClass('fa-eye');
              window.activeViewTable = table;
            } else {
              window.activeViewTable = '';
            }

            // 💾 Simpan nama tabel terakhir
            if (response.activeTable) {
              localStorage.setItem('lastSidebarTable', response.activeTable);
              console.log('💾 Update tabel terakhir:', response.activeTable);
            }

            // 🌀 Jika dinonaktifkan → reload halaman
            if (!newActive) {
              setTimeout(() => {
                location.reload();
              }, 1500);
            }
          } else {
            Swal.fire('Gagal!', response.message || 'Operasi gagal.', 'error');
          }
        },
        error: function (xhr) {
          Swal.close();
          console.error('Error Response:', xhr.responseText);
          Swal.fire('Error!', 'Terjadi kesalahan pada server.', 'error');
        },
        complete: function () {
          // 🔁 Kembalikan tampilan tombol seperti semula
          $btn.prop('disabled', false).html(`<i class="${originalIcon}"></i> ${originalText}`);
        },
      });
    });
  });


// === Setelah halaman direfresh, klik otomatis sidebar terakhir ===
$(document).ready(function () {
  const lastTable = localStorage.getItem('lastSidebarTable');
  if (lastTable) {
    const $link = $('.table-link[data-table="' + lastTable + '"]');
    if ($link.length) {
      console.log('🔁 Memuat ulang tabel terakhir:', lastTable);
      setTimeout(() => {
        $link.trigger('click');
      }, 400);
    }
  }
});


// === ⚡️ ActiveView Smart Reload (tanpa reload seluruh halaman) ===
(function () {
  'use strict';

  // 🔍 Cek apakah sedang ActiveView
  function isActiveView() {
    return Boolean(window.activeViewTable && typeof window.activeViewTable === 'string');
  }

  // 🔁 Fungsi untuk me-reload konten tabel aktif saja
  function reloadActiveViewContent() {
    if (!isActiveView()) return;

    const table = window.activeViewTable;
    const $link = $('.table-link[data-table="' + table + '"]');

    if ($link.length) {
      Swal.fire({
        title: 'Memuat ulang...',
        text: `Memuat ulang konten tabel "${table}"`,
        icon: 'info',
        timer: 1000,
        showConfirmButton: false,
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading(),
      });

      setTimeout(() => {
        console.log('🔁 Reload konten ActiveView:', table);
        $link.trigger('click'); // klik sidebar otomatis untuk reload konten
      }, 600);
    } else {
      console.warn('⚠️ Tidak ditemukan link sidebar untuk tabel:', table);
    }
  }

  // 🧠 Tangkap event reload (F5 / Ctrl+R / Cmd+R)
  $(document).on('keydown', function (e) {
    const key = e.which || e.keyCode;
    const isReloadKey =
      key === 116 || // F5
      (key === 82 && (e.ctrlKey || e.metaKey)); // Ctrl+R / Cmd+R

    if (isReloadKey && isActiveView()) {
      e.preventDefault(); // cegah reload seluruh halaman
      reloadActiveViewContent(); // muat ulang konten tabel saja
    }
  });

  // 🧩 Tombol UI reload (jika ada di dalam halaman)
  $(document).on('click', '.btn-reload, [data-action="reload"]', function (e) {
    if (isActiveView()) {
      e.preventDefault();
      reloadActiveViewContent();
      return false;
    }
    location.reload(); // fallback jika tidak sedang activeView
  });

  // 🧩 Simpan tabel terakhir supaya tetap bisa direstore
  $(document).on('click', '.table-link', function () {
    const table = $(this).data('table');
    if (table) localStorage.setItem('lastSidebarTable', table);
  });

  // 🧩 Setelah halaman dimuat ulang (biasa), klik otomatis sidebar terakhir
  $(document).ready(function () {
    const lastTable = localStorage.getItem('lastSidebarTable');
    if (lastTable && !isActiveView()) {
      const $link = $('.table-link[data-table="' + lastTable + '"]');
      if ($link.length) {
        console.log('🔁 Memuat tabel terakhir setelah reload:', lastTable);
        setTimeout(() => {
          $link.trigger('click');
        }, 500);
      }
    }
  });

})();

