<div id="crud-content">

    <!-- 🔹 Judul Tabel -->
    <div class="mb-2">
        <h4 class="fw-bold text-primary text-uppercase mb-1">
            <i class="fas <?= esc($icon ?? 'fa-database') ?> me-2"></i>
            Data <?= ucwords(str_replace('_', ' ', esc($table))) ?>
        </h4>

        <?php
        // 🔹 Ambil session & status Active View
        $session       = session();
        $activeViewTable = $session->get('activeViewTable');
        $isActiveView    = isset($isActiveView) && $isActiveView;
        $sessionTable    = $session->get('activeViewTable') ?? $table;
        ?>

        <!-- 🔹 Info & Tombol Clear Active View -->
        <?php if ($isActiveView): ?>
            <div class="alert alert-info text-center shadow-sm mb-3">
                <i class="fa fa-eye"></i>
                Tampilan ini menggunakan <b>Active View</b> dari tabel konfigurasi
                <code><?= esc($sessionTable) ?></code> untuk <b><?= esc($table) ?></b>.

            </div>
        <?php endif; ?>

        <hr class="mt-3 mb-2">
    </div>

    <!-- 🔹 Dua kolom informasi -->
    <div class="row mb-2 align-items-stretch">
        <!-- Kolom kiri -->
        <div class="col-md-6 mb-1">
            <div class="card shadow-sm border-0 bg-light h-100">
                <div class="card-body p-1">
                    <h6 class="card-title mb-1" style="font-size: 0.85rem;">
                        <i class="fas fa-info-circle text-primary mr-1"></i> Informasi Tabel
                    </h6>
                    <p class="card-text mb-0 text-muted" style="font-size: 0.75rem; line-height: 1;">
                        <?php
                        if (!empty($infoTabel)) {
                            echo strip_tags($infoTabel, '<p><b><i><u><strong><em><br><ul><ol><li><a>');
                        } else {
                            echo 'Tabel <strong>' . ucwords(str_replace('_', ' ', esc($table))) . '</strong> berisi data penting yang digunakan untuk pengelolaan sistem.';
                        }
                        ?>
                    </p>
                </div>
            </div>
        </div>

        <!-- Kolom kanan -->
        <div class="col-md-6 mb-1">
            <div class="card shadow-sm border-0 bg-light h-100">
                <div class="card-body p-1">
                    <h6 class="card-title mb-1" style="font-size: 0.85rem;">
                        <i class="fas fa-lightbulb text-warning mr-1"></i> Panduan Pengguna
                    </h6>
                    <p class="card-text mb-0 text-muted" style="font-size: 0.75rem; line-height: 1;">
                        <?php
                        if (!empty($infoUser)) {
                            echo strip_tags($infoUser, '<p><b><i><u><strong><em><br><ul><ol><li><a>');
                        } else {
                            echo 'Gunakan tombol <strong>Tambah</strong> untuk menambah data baru, atau klik <strong>Edit</strong> untuk memperbarui data yang ada.';
                        }
                        ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- 🔹 Tombol CRUD utama -->
    <div class="d-flex justify-content-between align-items-center mb-1">
        <div class="d-flex justify-content-end mb-1">
            <div class="btn-group" role="group">
                <?php
                // ✅ Gunakan tabel dari session jika sedang ActiveView
                $targetTable = $isActiveView ? $activeViewTable : $table;
                ?>

                <?php if (!empty($buttons)): ?>
                    <?php if ($buttons['tambah'] === 'aktif'): ?>
                        <button id="btn-tambah-<?= esc($targetTable) ?>"
                            class="btn btn-sm btn-primary btn-add"
                            data-table="<?= esc($targetTable) ?>">
                            <i class="fas fa-plus mr-1"></i> Tambah
                        </button>
                    <?php endif; ?>

                    <?php if ($buttons['export'] === 'aktif'): ?>
                        <button id="btn-export-<?= esc($targetTable) ?>"
                            class="btn btn-sm btn-success btn-export"
                            data-table="<?= esc($targetTable) ?>">
                            <i class="fas fa-file-export mr-1"></i> Export
                        </button>
                    <?php endif; ?>

                    <?php if ($buttons['import'] === 'aktif'): ?>
                        <button id="btn-import-<?= esc($targetTable) ?>"
                            class="btn btn-sm btn-warning btn-import"
                            data-table="<?= esc($targetTable) ?>">
                            <i class="fas fa-file-import mr-1"></i> Import
                        </button>
                    <?php endif; ?>

                    <?php if ($buttons['print'] === 'aktif'): ?>
                        <button id="btn-print-<?= esc($targetTable) ?>"
                            class="btn btn-sm btn-secondary btn-print"
                            data-table="<?= esc($targetTable) ?>">
                            <i class="fas fa-print mr-1"></i> Print
                        </button>
                    <?php endif; ?>

                    <?php if ($buttons['generate'] === 'aktif'): ?>
                        <button id="btn-generate-<?= esc($targetTable) ?>"
                            class="btn btn-sm btn-info btn-generate"
                            data-table="<?= esc($targetTable) ?>">
                            <i class="fas fa-cogs mr-1"></i> Generate
                        </button>
                    <?php endif; ?>

                    <?php if ($buttons['delete_all'] === 'aktif'): ?>
                        <button id="btn-deleteall-<?= esc($targetTable) ?>"
                            class="btn btn-sm btn-danger btn-delete-all"
                            data-table="<?= esc($targetTable) ?>">
                            <i class="fas fa-trash-alt mr-1"></i> Delete All
                        </button>
                    <?php endif; ?>

                    <?php if ($buttons['activeView'] === 'aktif'): ?>
                        <?php
                        // Ambil dari session
                        $activeViewTable = session()->get('activeViewTable');
                        $isActiveViewMode = session()->get('isActiveViewMode');

                        // ✅ Kondisi tombol aktif:
                        // tombol hijau kalau mode aktif ON dan tabel ini adalah yang sedang aktif
                        // ATAU kalau mode aktif ON (supaya tetap hijau di tabel lain)
                        $isActive = false;
                        if ($isActiveViewMode) {
                            $isActive = true;
                        } elseif ($activeViewTable === $table) {
                            $isActive = true;
                        }
                        ?>
                        <button id="btn-activeview-<?= esc($targetTable) ?>"
                            class="btn btn-sm <?= $isActive ? 'btn-success' : 'btn-secondary' ?> activeView"
                            data-table="<?= esc($targetTable) ?>">
                            <i class="fas <?= $isActive ? 'fa-eye' : 'fa-check' ?> mr-1"></i>
                            ActiveView
                        </button>
                    <?php endif; ?>

                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table id="datatable" class="table table-bordered table-striped table-hover">
            <thead>
                <tr>
                    <th>No</th> <!-- Kolom Nomor -->
                    <?php foreach ($fields as $field): ?>
                        <th><?= ucfirst(esc($field)) ?></th>
                    <?php endforeach; ?>
                    <th>Aksi</th>
                </tr>
            </thead>

            <tbody>
                <?php if (!empty($rows)): ?>
                    <?php
                    $no = 1;
                    // ✅ Tentukan tabel aktif (ActiveView atau normal)
                    $tableName = isset($isActiveView) && $isActiveView
                        ? session()->get('activeViewTable')
                        : $table;
                    ?>
                    <?php foreach ($rows as $row): ?>
                        <tr data-id="<?= esc($row[$meta[0]['name']] ?? '') ?>">
                            <td><?= $no++; ?></td>

                            <?php foreach ($fields as $field): ?>
                                <td>
                                    <?php if (in_array($field, $toggleFields) && isset($row[$field]) && in_array($row[$field], ['aktif', 'nonaktif'])): ?>
                                        <div class="d-flex justify-content-center align-items-center" style="min-height:50px;">
                                            <div class="custom-control custom-switch">
                                                <input
                                                    type="checkbox"
                                                    class="custom-control-input toggle-status"
                                                    id="switch_<?= esc($tableName) ?>_<?= esc($field) ?>_<?= esc($row[$meta[0]['name']] ?? '') ?>"
                                                    data-table="<?= esc($tableName) ?>"
                                                    data-id="<?= esc($row[$meta[0]['name']] ?? '') ?>"
                                                    data-column="<?= esc($field) ?>"
                                                    <?= $row[$field] === 'aktif' ? 'checked' : '' ?>>
                                                <label
                                                    class="custom-control-label"
                                                    for="switch_<?= esc($tableName) ?>_<?= esc($field) ?>_<?= esc($row[$meta[0]['name']] ?? '') ?>">
                                                    <?= $row[$field] === 'aktif' ? 'ON' : 'OFF' ?>
                                                </label>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <?= esc($row[$field] ?? '') ?>
                                    <?php endif; ?>
                                </td>
                            <?php endforeach; ?>

                            <!-- 🔹 Tombol Aksi (View, Edit, Delete) -->
                            <td>
                                <?php if ($buttons['view'] === 'aktif'): ?>
                                    <button
                                        id="btn-view-<?= esc($tableName) ?>-<?= esc($row[$meta[0]['name']] ?? '') ?>"
                                        class="btn btn-sm btn-info view-btn"
                                        data-table="<?= esc($tableName) ?>"
                                        data-id="<?= esc($row[$meta[0]['name']] ?? '') ?>">
                                        <i class="fas fa-eye mr-1"></i> View
                                    </button>
                                <?php endif; ?>

                                <?php if ($buttons['edit'] === 'aktif'): ?>
                                    <button
                                        id="btn-edit-<?= esc($tableName) ?>-<?= esc($row[$meta[0]['name']] ?? '') ?>"
                                        class="btn btn-sm btn-warning edit-btn"
                                        data-table="<?= esc($tableName) ?>"
                                        data-id="<?= esc($row[$meta[0]['name']] ?? '') ?>">
                                        <i class="fas fa-edit mr-1"></i> Edit
                                    </button>
                                <?php endif; ?>

                                <?php if ($buttons['delete'] === 'aktif'): ?>
                                    <button
                                        id="btn-delete-<?= esc($tableName) ?>-<?= esc($row[$meta[0]['name']] ?? '') ?>"
                                        class="btn btn-sm btn-danger delete-btn"
                                        data-table="<?= esc($tableName) ?>"
                                        data-id="<?= esc($row[$meta[0]['name']] ?? '') ?>">
                                        <i class="fas fa-trash mr-1"></i> Hapus
                                    </button>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                <?php else: ?>
                    <tr class="no-data">
                        <td>—</td>
                        <?php foreach ($fields as $field): ?>
                            <td>—</td>
                        <?php endforeach; ?>
                        <td class="text-center text-muted">Tidak ada data</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php
    // ✅ Tentukan tabel aktif yang sedang digunakan (ActiveView atau normal)
    $tableName = isset($isActiveView) && $isActiveView
        ? (session()->get('activeViewTable') ?? $table)
        : $table;
    ?>

    <!-- ✅ Modal Tambah/Edit -->
    <div class="modal fade" id="formModal" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <form id="crudForm">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">Form <?= esc($activeViewTable) ?></h5>
                        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                    </div>

                    <div class="modal-body p-3 scrollable">
                        <div class="table-responsive">
                            <table class="table table-borderless table-sm mb-0" id="crudFormTable">
                                <tbody>
                                    <!-- JS akan mengisi field otomatis di sini -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- ✅ Modal Import -->
    <div class="modal fade" id="importModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="importForm" enctype="multipart/form-data">
                    <div class="modal-header">
                        <h5 class="modal-title">Import Data <?= esc($activeViewTable) ?></h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Pilih file Excel (.xls / .xlsx)</label>
                            <input type="file" name="file" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">Upload</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- ✅ Modal View (Detail) -->
    <div class="modal fade" id="viewModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-secondary text-white">
                    <h5 class="modal-title">Detail Data <?= esc($activeViewTable) ?></h5>
                    <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div id="viewContent" class="p-3">
                        <!-- Konten detail diisi oleh JS -->
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>
</div> <!-- ✅ Penutup utama #crud-content -->


<?php if (isset($isActiveView) && $isActiveView): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'info',
                title: 'Active View Aktif',
                html: `
                    Data ini sedang menggunakan <b>tabel konfigurasi</b>:<br>
                    <code><?= esc($sessionTable) ?></code><br>
                    untuk tampilan <b><?= esc($table) ?></b>.
                `,
                timer: 4000,
                timerProgressBar: true,
                showConfirmButton: false
            });
        });
    </script>
<?php endif; ?>