<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\GenericModel;

class CrudBaseController extends Controller
{
    protected $db;
    protected $model;
    protected $session;
    protected $userRole;

    public function __construct()
    {
        helper(['url', 'form']);

        // ✅ Tidak perlu panggil parent::__construct()

        // Inisialisasi global
        $this->session = session();
        $this->model   = new GenericModel();
        $this->db      = \Config\Database::connect();

        // Ambil role user dari session, fallback ke 'guest'
        $this->userRole = $this->session->get('user_role') ?? 'user';
    }

    protected function jsonResponse($status, $message, $data = [])
    {
        return $this->response->setJSON(array_merge([
            'status' => $status,
            'message' => $message,
            'role' => $this->userRole
        ], $data));
    }
}
